/*
This header file implements the clipping algorithms.  Both
Cohen-Sutherland line clipping, and Sutherland-  polygon clipping
are implemented here.

  Michael Chungkun Chen
  002-764-157
*/
#ifndef clipping
#define clipping

#include "include.h"    //Header files for GL, for windows and unix
#include "objtypes.h"   //Structures used for the objects

void cosu_code(double xmin,double xmax,double ymin,double ymax,struct linetype *retline)
{
	struct linetype *line, *newl;
	polygon *poly;
	vertex *plst, v;
	double lastx,lasty, firstx, firsty,z,w;
	int firstcode, lastcode, code;

	retline->next=line=(struct linetype *) malloc(sizeof(struct linetype));
	newl=retline;
	poly=screen.getnext();
	while (poly!=NULL)
	{
		poly->get(v);
        plst=v.gethead();
        plst->get(lastx,lasty,z,w,color);
		firstx=lastx;
		firsty=lasty;
		code=0;
		if (lastx>xmax)
			code=code | RIGHT;
		if (lastx<xmin)
			code=code | LEFT;
		if (lasty>ymax)
			code=code | TOP;
		if (lasty<ymin)
			code=code | BOTTOM;
		firstcode=lastcode=code;
		plst=plst->getnext();
		while (plst!=NULL)
		{
			line->x=lastx;
			line->y=lasty;	
			line->code1=lastcode;
		
			line->color=color;
                //poly->color;
	
            plst->get(lastx,lasty,z,w,color);
			line->x2=lastx;
			line->y2=lasty;
			code=0;
			if (lastx>xmax)
				code=code | RIGHT;
			if (lastx<xmin)
				code=code | LEFT;
			if (lasty>ymax)
				code=code | TOP;
			if (lasty<ymin)
				code=code | BOTTOM;
			line->code2=lastcode=code;
			line=line->next=(struct linetype *) malloc(sizeof(struct linetype));
			plst=plst->getnext();
		}
		line->x=lastx;
		line->y=lasty;
		line->code1=lastcode;
		line->color=blue;
            //poly->color;

		line->x2=firstx;
		line->y2=firsty;
		line->code2=firstcode;
		line->next=(struct linetype *) malloc(sizeof(struct linetype));
		newl=line;
    	line=line->next;
    	poly=poly->getnext();
    }
    free(line);
	newl->next=NULL;
}

void cosu_clip(double xmin,double xmax,double ymin,double ymax,struct linetype *retline)
{
    struct linetype *l,*prev;
    double m;

    prev=retline;
    l=retline->next;
    while (l!=NULL)
    {
        if ((l->code1 | l->code2)==0)
        {
            prev=l;
            l=l->next;
        }
        else if ((l->code1 & l->code2)!=0)
        {
            prev->next=prev->next->next;
            free(l);
            l=prev->next;
        }
        else if (l->code1!=0)
        {
            m=(l->y-l->y2)/(l->x-l->x2);
            if ((l->code1 & TOP) !=0)
            {
                l->x=(ymax-l->y2)/m+l->x2;
                l->y=ymax;
            }

            if ((l->code1 & BOTTOM) !=0)
            {
                l->x=(ymin-l->y2)/m+l->x2;
                l->y=ymin;
            }

            if ((l->code1 & RIGHT) !=0)
            {
                l->y=(xmax-l->x2)*m+l->y2;
                l->x=xmax;
            }

            if ((l->code1 & LEFT) !=0)
            {
                l->y=(xmin-l->x2)*m+l->y2;
                l->x=xmin;
            }  
            l->code1=0;
            if (l->x>xmax)
                l->code1=l->code1 | RIGHT;
            if (l->x<xmin)
                l->code1=l->code1 | LEFT;
            if (l->y>ymax)
                l->code1=l->code1 | TOP;
            if (l->y<ymin)
                l->code1=l->code1 | BOTTOM;
        }
        else if (l->code2!=0)
        {
            m=(l->y2-l->y)/(l->x2-l->x);
            if ((l->code2 & TOP) !=0)
            {
                l->x2=(ymax-l->y)/m+l->x;
                l->y2=ymax;
            }

            if ((l->code2 & BOTTOM) !=0)
            {
                l->x2=(ymin-l->y)/m+l->x;
                l->y2=ymin;
            }

            if ((l->code2 & RIGHT) !=0)
            {
                l->y2=(xmax-l->x)*m+l->y;
                l->x2=xmax;
            }

            if ((l->code2 & LEFT) !=0)
            {
                l->y2=(xmin-l->x)*m+l->y;
                l->x2=xmin;
            }            
            l->code2=0;
            if (l->x2>xmax)
                l->code2=l->code2 | RIGHT;
            if (l->x2<xmin)
                l->code2=l->code2 | LEFT;
            if (l->y2>ymax)
                l->code2=l->code2 | TOP;
            if (l->y2<ymin)
                l->code2=l->code2 | BOTTOM;
        }
    }

}

void polycode(double x, double y, double z, double w, double c1[])
{
    c1[0]=w+x;
    c1[1]=w-x;
    c1[2]=w+y;
    c1[3]=w-y;
    c1[4]=z;
    c1[5]=w-z;
}


void clipcode(double &x,double &y,double &z,double &w,
              double &xx,double &yy,double &zz,double &ww, int &toss, int &change)
{
    double c1[6],c2[6],t;
    int i;
    double zero=0.000001;

    polycode(x,y,z,w,c1);
    polycode(xx,yy,zz,ww,c2);
    toss=0;
    change=0;
  for(i=0;i<6;i++)
  {
    if ((c1[i]<zero) && (c2[i]<zero))
    {
        toss=1;
        return;
    }
    else if ((c1[i]>zero) && (c2[i]>zero))
    {
    }
    else if ((c1[i]<zero)||(c2[i]<zero))
    {
        t=c1[i]/(c1[i]-c2[i]);
        if (c2[i]>=zero)
        {
            change=1;
            x=x+t*(xx-x);
            y=y+t*(yy-y);
            z=z+t*(zz-z);
            w=w+t*(ww-w);
            polycode(x,y,z,w,c1);
        }
        else
        {
            xx=x+t*(xx-x);
            yy=y+t*(yy-y);
            zz=z+t*(zz-z);
            ww=w+t*(ww-w);
            polycode(xx,yy,zz,ww,c2);
        }
    }
  }//end for
}

void clip(vertex v, vertex *out)
{
    vertex *idx, ret;
    double x,y,z,w;
    double xo,yo,zo,wo;
    double x2,y2,z2,w2;
    GLfloat *c1, *c2, *co;
    int toss=0, change=0;

    ret.reset();
    idx=v.gethead();
    idx->get(x,y,z,w,c1);
    while ((idx!=NULL) && (idx->getnext()!=NULL))
    {
        idx->getnext()->get(x2,y2,z2,w2,c2);
        xo=x2;
        yo=y2;
        zo=z2;
        wo=w2;
        co=c2;
        clipcode(x,y,z,w,x2,y2,z2,w2,toss, change);
        if (toss==0)
        {
            if (change==1) ret.add(x,y,z,w,c1);
            ret.add(x2,y2,z2,w2,c2);
        }
        x=xo;
        y=yo;
        z=zo;
        w=wo;
        c1=co;
        idx=idx->getnext();
    }
    v.gethead()->get(x2,y2,z2,w2,c2);
    clipcode(x,y,z,w,x2,y2,z2,w2,toss, change);
        if (toss==0)
        {
            if (change==1) ret.add(x,y,z,w,c1);
            ret.add(x2,y2,z2,w2,c2);
        }
    *out=ret.getnext();
}


void poly_clip(polygon t,polygon &poly)
{
	polygon *p;
    vertex v,v2;

	p=t.getnext();
    poly.reset();
	while (p!=NULL)
	{
        p->get(v);
        clip(v,&v2);  
        poly.addall(v2);
        p=p->getnext();
	}
}

#endif
