/*
This header file is used to implement the polygon fill with active
edge list.

  Michael Chungkun Chen
  002-764-157

*/
#ifndef extra
#define extra

#include "include.h"
#include "objtypes.h"
#include "matrix.h"

struct edgelist
{
    double ymax, xmin, invm, bz, addzy;
    GLfloat *color;
    polygon *p;
    struct edgelist *next;
};

struct actedgelist
{
    double ymax, x, invm, currzy, addzy;
    int xx;
    GLfloat *color;
    polygon *p;
    struct actedgelist *next;
};

struct inlist
{
    double curz,incz;
    GLfloat color[4];
    polygon *p;
    struct inlist *next;
};

int t(double x, double h, int c)
{
    return (int)(c+x*h+0.5);
}

void killlist(struct edgelist *el[])
{
    struct edgelist *idx, *tmp;
    int x;

    for(x=0;x<winSizeY;x++)
    {
        idx=el[x];
        while (idx!=NULL)
        {
            tmp=idx;
            idx=idx->next;
            free(tmp);
        }
    }
}

void setedgelist(polygon *p, struct edgelist *el[])
{
    vertex *idx, v;
    struct edgelist *newedge;
    double xx,yy,zz,ww;
    double xx2,yy2,zz2,ww2;
    GLfloat *cc,*cc2;
    int y;

    p->get(v);
    idx=v.gethead();
    v.get(xx,yy,zz,ww,cc);
    xx=t(xx,hx,cx);
    yy=t(yy,hy,cy);
    while (idx->getnext()!=NULL)
    {
        idx->getnext()->get(xx2,yy2,zz2,ww2,cc2);
        xx2=t(xx2,hx,cx);
        yy2=t(yy2,hy,cy);

        if (yy<yy2)
        {
            y=(int)(yy+0.5);
            newedge=(struct edgelist *)malloc(sizeof(struct edgelist));
            newedge->bz=zz;
            newedge->p=p;
            newedge->addzy=(zz2-zz)/(yy2-yy);
            newedge->color=cc;
            newedge->ymax=yy2;
            newedge->xmin=xx;
            newedge->invm=(xx2-xx)/(yy2-yy);
            newedge->next=el[y];
            el[y]=newedge;
        }
        else if (yy>yy2)
        {
            y=(int)(yy2+0.5);
            newedge=(struct edgelist *)malloc(sizeof(struct edgelist));
            newedge->bz=zz2;
            newedge->addzy=(zz-zz2)/(yy-yy2);
            newedge->p=p;
            newedge->color=cc;
            newedge->ymax=yy;
            newedge->xmin=xx2;
            newedge->invm=(xx-xx2)/(yy-yy2);
            newedge->next=el[y];
            el[y]=newedge;
        }
        xx=xx2;
        yy=yy2;
        zz=zz2;
        ww=ww2;
        cc=cc2;
        idx=idx->getnext();
    }
        v.get(xx2,yy2,zz2,ww2,cc2);
        xx2=t(xx2,hx,cx);
        yy2=t(yy2,hy,cy);

        if (yy<yy2)
        {
            y=(int)(yy+0.5);
            newedge=(struct edgelist *)malloc(sizeof(struct edgelist));
            newedge->bz=zz;
            newedge->addzy=(zz2-zz)/(yy2-yy);
            newedge->p=p;
            newedge->color=cc;
            newedge->ymax=yy2;
            newedge->xmin=xx;
            newedge->invm=(xx2-xx)/(yy2-yy);
            newedge->next=el[y];
            el[y]=newedge;
        }
        else if (yy>yy2)
        {
            y=(int)(yy2+0.5);
            newedge=(struct edgelist *)malloc(sizeof(struct edgelist));
            newedge->bz=zz2;
            newedge->addzy=(zz-zz2)/(yy-yy2);
            newedge->p=p;
            newedge->color=cc;
            newedge->ymax=yy;
            newedge->xmin=xx2;
            newedge->invm=(xx-xx2)/(yy-yy2);
            newedge->next=el[y];
            el[y]=newedge;
        }
}

void add(struct actedgelist *ael, struct edgelist *el, int scanline)
{
    struct edgelist *idx;
    struct actedgelist *temp;
    idx=el;
    while (idx!=NULL)
    {
        temp=(struct actedgelist *)malloc(sizeof(struct actedgelist));
        temp->currzy=idx->bz;
        temp->addzy=idx->addzy;
        temp->color=idx->color;
        temp->p=idx->p;
        temp->invm=idx->invm;
        temp->x=idx->xmin;
        temp->xx=(int)(temp->x+0.5);
        temp->ymax=idx->ymax;
        temp->next=ael->next;
        ael->next=temp;
        idx=idx->next;
    }
}

void del(struct actedgelist *ael, int scanline)
{
    struct actedgelist *idx, *temp;
    idx=ael;
    while ((idx!=NULL) && (idx->next!=NULL))
    {
            if(idx->next->ymax<scanline)
            {
                temp=idx->next;
                idx->next=idx->next->next;
                free(temp);
            }
            else
                idx=idx->next;
    }
    if(ael->next!=NULL)
      if(ael->next->ymax<scanline)
      {
       temp=ael->next;
       ael->next=ael->next->next;
       free(temp);
      }    

}

void sortlist(struct actedgelist *ael)
{
	struct actedgelist *loc, *loc2, *ploc;
	if (ael->next==NULL) return;
    //Radix sort by p first
    ploc=ael->next->next;
	loc=ploc;
    ael->next->next=NULL;
	while (loc!=NULL)
	{
		loc2=ael;
		while ((loc2->next!=NULL) && (loc2->next->p<loc->p))
		{
			loc2=loc2->next;
		}
		ploc=ploc->next;
		loc->next=loc2->next;
		loc2->next=loc;
    	loc=ploc;
	}
    //Radix sort by x
    ploc=ael->next->next;
	loc=ploc;
    ael->next->next=NULL;
	while (loc!=NULL)
	{
		loc2=ael;
		while ((loc2->next!=NULL) && (loc2->next->x<loc->x))
		{
			loc2=loc2->next;
		}
		ploc=ploc->next;
		loc->next=loc2->next;
		loc2->next=loc;
    	loc=ploc;
	}
}

void equ(GLfloat o[],GLfloat *p)
{
    o[0]=p[0];
    o[1]=p[1];
    o[2]=p[2];
    o[3]=p[3];
}

void filllist(struct actedgelist *ael,int scanline, int maxx)
{
    struct actedgelist *idx;
    struct inlist *idx2, *in, *tmp;
    vertex v;
    col norm;
    int preva,again, out, currx;
    double oz,z;
    double min=-9999999;
    GLfloat oc[4], *buf;

    buf=(GLfloat *)malloc(4*sizeof(GLfloat)*(maxx+1));
    in=(struct inlist *)malloc(sizeof(struct inlist));
    in->next=NULL;
    in->p=NULL;
    
    idx=ael->next;
    out=0;
    again=0;
    equ(oc,colorb);
    currx=0;
    preva=0;
    while (currx<maxx)
    {
        out=0;
        equ(oc,colorb);
        oz=min;
        idx2=in;

        while ((idx2!=NULL) && (idx2->next!=NULL))
        {
            tmp=idx2->next;
            if (!again) tmp->curz+=tmp->incz;
            z=tmp->curz;
            if (z>=oz)
            {
                equ(oc,tmp->color);
                oz=z;
            }
            if ((idx!=NULL) && ((tmp->p==idx->p) && (idx->xx==currx)))
            {         
                idx2->next=tmp->next;
                free(tmp);
                out=1;
                idx=idx->next;
                again=1;
                preva=0;
            }
            else
                idx2=idx2->next;
        }
        buf[currx*4+0]=oc[0];
        buf[currx*4+1]=oc[1];
        buf[currx*4+2]=oc[2];
        buf[currx*4+3]=oc[3];

        if (idx!=NULL)
        {
         if ((out!=1) && (idx->xx==currx))
         {
           idx2->next=(struct inlist *)malloc(sizeof(struct inlist));
           tmp=idx2->next;
           tmp->p=idx->p;
           tmp->p->get(norm);
           tmp->curz=(norm[0]*(currx-cx)/hx+norm[1]*(scanline-cy)/hy+norm[3])/norm[2];
           tmp->incz=(norm[0]*(1/hx)/norm[2]);
           tmp->p->get(tmp->color);
           tmp->next=NULL;
           idx=idx->next;
           again=1;
           preva=0;
         }
        }
        //continue onto next in list or intersetcion
       if (preva==1)
       {
           preva=0;
           again=0;
       }
       if (!again)
           currx++;
       else
           preva=1;
    }
    glRasterPos2i( 1, scanline );//Set location
    glDrawPixels((maxx) , 1, GL_RGBA, GL_FLOAT, ( GLvoid * ) buf );
    free(buf);
}

void updatelist(struct actedgelist *ael)
{
    struct actedgelist *idx;
    idx=ael;
    while (idx!=NULL)
    {
        idx->currzy+=idx->addzy;
        idx->x+=idx->invm;
        idx->xx=(int)(idx->x+0.5);
        idx=idx->next;
    }
}

void polyfill(polygon p,int maxx)
{
    struct edgelist **el;
    struct actedgelist *ael;
    int x;
    polygon *idx;
    vertex v;

    el=(struct edgelist **)malloc(sizeof(struct edgelist)*winSizeY);
    for(x=1;x<=winSizeY; x++)
        el[x-1]=NULL;

    ael=(struct actedgelist *)malloc(sizeof(struct actedgelist));
    ael->next=NULL;
    idx=p.gethead();
    while (idx!=NULL)
    {
        setedgelist(idx,el);
        idx=idx->getnext();
    }

    for (x=0;x<winSizeY;x++)
    {
        del(ael,x+1);
        add(ael,el[x],x);
        sortlist(ael);
        filllist(ael,x,maxx);
        updatelist(ael);
/*
        if (x%10==0)
        {
            glRasterPos2i( winSizeX-100, x );//Set location
            glDrawPixels(1 , 1, GL_RGBA, GL_FLOAT, ( GLvoid * ) white );
        }
//*/
    }

    glFlush();
    killlist(el);
    free(ael);
}

#endif
