/*
This header file implements most of the basic functionality needed
for this lab.  It handles generation of objects, drawing, and viewing.

  Michael Chungkun Chen
  002-764-157
*/
#ifndef functions  //Makes sure we don't declare this more than once.
#define functions

#include "include.h"    //Header files for GL, for windows and unix
#include "objtypes.h"   //Structures used for the objects
#include "matrix.h"     //Matrix Math
#include "bres.h"       //Bresenham Algorithms from lab1.
#include "clipping.h"   //Clipping Algorithms from lab2 and 3d clipping
#include "extra.h"      //Polygon Fill from lab2
#include "structure.h"  //Vertex and Polygon list class
#include <string.h>     //String header used for tokenizer function.

#ifdef WIN32
#include <conio.h>		//For Windows systems
#endif

/************************************************************************/
void kbwait()
{
#ifndef WIN32
    FILE *fp;
#endif
		/* wait for ENTER/RETURN key to be hit */ 
		printf( "\n(hit ENTER/RETURN to continue...)" ); 
#ifdef WIN32
	    while (!kbhit());
		_getch();
#else    
        if( ( fp = fopen( "/dev/tty","r" ) ) == NULL )
		{ 
	        fprintf( stderr, "could not open /dev/tty\n" ); 
		    exit(5); 
		}
		fgetc( fp ); 
		fclose( fp ); 
#endif
}

void detail(const char *info, matrix m)
{
#ifdef MATRIXOUT
    printf("\nMatrix pertains to: %s.\n",info);
    printf("%f %f %f %f\n%f %f %f %f\n%f %f %f %f\n%f %f %f %f\n",m[0][0],m[0][1],m[0][2],m[0][3],
           m[1][0],m[1][1],m[1][2],m[1][3],m[2][0],m[2][1],m[2][2],m[2][3],m[3][0],m[3][1],m[3][2],m[3][3]);
#endif
}

void printout(col nor, GLfloat *c)
{
#ifdef MATRIXOUT
    printf("N: %f %f %f %f  C: %f %f %f %f\n",nor[0],nor[1],nor[2],nor[3],c[0],c[1],c[2],c[3]);
#endif
}

void printlight()
{
#ifdef MATRIXOUT
    int i;
    for (i=0;i<10;i++)
    {
    printf("Light: %d -->",i);
    printf("%f %f %f %f\n",lights[i].x, lights[i].y, lights[i].z, lights[i].i);
    }
#endif
}

/**********************************************************************/

void box(int x1,int x2,int y1,int y2)
{
    color=white;
    Bres_Line(x1,y1,x1,y2);
    Bres_Line(x2,y1,x2,y2);
    Bres_Line(x1,y1,x2,y1);
    Bres_Line(x1,y2,x2,y2);
}

void calcolor(GLfloat c[],GLfloat *cc, col norm,col view, double kd, double ks, double ni, double x, double y, double z)
{
    int idxc,idxl;
    double fac,fac2;
    col liv, R;
    
    for (idxc=0;idxc<3;idxc++)
    {
        c[idxc]=(GLfloat)ambient*cc[idxc];
        for(idxl=0;idxl<10;idxl++)
        {
            liv[0]=lights[idxl].x-x;
            liv[1]=lights[idxl].y-y;
            liv[2]=lights[idxl].z-z;
            liv[3]=0;
            unit(liv);
            dot(liv,norm,fac);

            if (fac>-0.000000001)
            {     
                R[0]=2*fac*norm[0]-liv[0];
                R[1]=2*fac*norm[1]-liv[1];
                R[2]=2*fac*norm[2]-liv[2];
                R[3]=0;
                unit(R);
                
                dot(R,view,fac2);

                c[idxc]+=(GLfloat)(lights[idxl].i*(cc[idxc]*kd*fac+ks*pow(fac2,ni)));
            }
        }
        if (c[idxc]>1) c[idxc]=1;
        if (c[idxc]<0) c[idxc]=0;
    }
    c[3]=1;
}

void change(polygon p1, polygon &p2, matrix in)
{
    polygon *idx, pp;
    vertex *idx2, v2,v;
    col b,c;
    GLfloat *cc;

    idx=p1.gethead();
    pp.reset();
    while (idx!=NULL)
    {
        idx->get(v);
        idx2=v.gethead();
        v2.reset();
        while (idx2!=NULL)
        {
            idx2->get(b[0],b[1],b[2],b[3],cc);
            cmmult(in,b,c);
            v2.add(c[0],c[1],c[2],c[3], cc);
            idx2=idx2->getnext();
        }
        pp.add(*v2.getnext());
        idx=idx->getnext();
    }
    p2=pp.getnext();
}

void change(vertex v, vertex &vout, matrix in)
{
    vertex *idx2, v2;
    col b,c;
    GLfloat *cc;

    idx2=v.gethead();
    v2.reset();
    while (idx2!=NULL)
    {
        idx2->get(b[0],b[1],b[2],b[3],cc);
        cmmult(in,b,c);
        v2.add(c[0],c[1],c[2],c[3], cc);
        idx2=idx2->getnext();
    }
    vout=*v2.getnext();
}

void change(struct light l2, struct light &l, matrix in)
{
    col b,c;
    b[0]=l2.x;
    b[1]=l2.y;
    b[2]=l2.z;
    b[3]=1;
    cmmult(in,b,c);
    l.x=c[0]/c[3];
    l.y=c[1]/c[3];
    l.z=c[2]/c[3];
    l.i=l2.i;
}

void perspective_div(polygon &p1)
{
    polygon *idx;
    vertex *idx2,v;
    double x,y,z,w;
    GLfloat *cc;

    idx=p1.gethead();
    while (idx!=NULL)
    {
        idx->get(v);
        idx2=v.gethead();
        while (idx2!=NULL)
        {
            idx2->get(x,y,z,w,cc);
            if (w==0) w=0.00000000000000000001;
            idx2->set(x/w,y/w,z/w,1,cc);
            idx2=idx2->getnext();
        }
        idx->set(v);
        idx=idx->getnext();
    }
}

void perspective_div(vertex &v)
{
    vertex *idx2;
    double x,y,z,w;
    GLfloat *cc;

    idx2=v.gethead();
    while (idx2!=NULL)
    {
       idx2->get(x,y,z,w,cc);
       if (w==0) w=0.00000000000000000001;
       idx2->set(x/w,y/w,z/w,1,cc);
       idx2=idx2->getnext();
    }
}

void draw(vertex v)
{
    vertex *idx;
    int x1,y1,x2,y2;
    double xr,yr;
  
//    color=blue;
    
    idx=v.getnext();
    v.get(xr,yr);
    x1=(int)(xr*hx+cx+0.5);
    y1=(int)(yr*hy+cy+0.5);
        while (idx!=NULL)
        {
            idx->get(xr,yr);
            x2=(int)(xr*hx+cx+0.5);
            y2=(int)(yr*hy+cy+0.5);
            Bres_Line(x1,y1,x2,y2);
            x1=x2;
            y1=y2;
            idx=idx->getnext();
        }
        v.get(xr,yr);
        x2=(int)(xr*hx+cx+0.5);
        y2=(int)(yr*hy+cy+0.5);
        Bres_Line(x1,y1,x2,y2);
}

void draw(struct linetype *line)
{
  struct linetype *ln;
  col out;
  int x1,x2,y1,y2;
  
  ln = line->next;
  while (ln!=NULL)
  {
    color=red;
    out[0]=cx+(ln->x*hx);
    out[1]=cy+(ln->y*hy);
    x1=(int)(out[0]+0.5);
    y1=(int)(out[1]+0.5);

    out[0]=cx+(ln->x2*hx);
    out[1]=cy+(ln->y2*hy);
    x2=(int)(out[0]+0.5);
    y2=(int)(out[1]+0.5);

    Bres_Line(x1,y1,x2,y2);
    ln=ln->next;
  }
  
}

void draw(polygon poly)
{
    polygon *idx;
    vertex v;
    if (Shade==1)
    {
        polyfill(poly,winSizeX);
    }
    else
    {
        color=blue;
        idx=poly.getnext();
        while (idx!=NULL)
        {
            idx->get(v);
            draw(v);
            idx=idx->getnext();
        }
    }
}


void scale(matrix &m,double x, double y, double z)
{
    matrix a,b;
    ident(a);
    a[0][0]=x;
    a[1][1]=y;
    a[2][2]=z;
    mmult(a,m,b);
    set(b,m);
}

void translate(matrix &m,double x, double y, double z)
{
    matrix a,b;
    ident(a);
    a[0][3]=x;
    a[1][3]=y;
    a[2][3]=z;
    mmult(a,m,b);
    set(b,m);
}

void rotate(matrix &m,double x, double y, double z)
{
    matrix a,b,c;
    double xr,yr,zr;

    xr=x/180*pi;
    yr=y/180*pi;
    zr=z/180*pi;

    ident(a);
    //x rotate
    ident(a);
    a[1][1]=cos(xr);
    a[1][2]=-sin(xr);
    a[2][1]=-a[1][2];
    a[2][2]=a[1][1];
    mmult(a,m,b);

    //y rotate
    ident(a);
    a[0][0]=cos(yr);
    a[0][2]=sin(yr);
    a[2][0]=-a[0][2];
    a[2][2]=a[0][0];
    mmult(a,b,c);

    //z rotate
    ident(a);
    a[0][0]=cos(zr);
    a[0][1]=-sin(zr);
    a[1][0]=-a[0][1];
    a[1][1]=a[0][0];
    mmult(a,c,m);
}

void makeEye(double px,double py,double pz,double ix,double iy,double iz)
{
    col a,b,c;

    eyex=px;
    eyey=py;
    eyez=pz;

    ident(eyet);
    translate(eyet,-px,-py,-pz);
    ident(eyem);

    a[0]=ix-px;
    a[1]=iy-py;
    a[2]=iz-pz;
    a[3]=0;
    b[0]=0;
    b[1]=1;
    b[2]=0;
    b[3]=0;
    cross(b,a,c);
    c[3]=0;
    cross(a,c,b);
    b[3]=0;
    unit(c);
    unit(b);
    unit(a);
    eyem[0][0]=c[0];
    eyem[0][1]=c[1];
    eyem[0][2]=c[2];
    eyem[1][0]=b[0];
    eyem[1][1]=b[1];
    eyem[1][2]=b[2];
    eyem[2][0]=a[0];
    eyem[2][1]=a[1];
    eyem[2][2]=a[2];

}

void makePM(double tilt,double hither,double yon,double halffov)
{
    double ang,cs,sn,tn;

    ident(tiltm);
    ang=-tilt*pi/180;
    sn=sin(ang);
    cs=cos(ang);
    
    //z rotate
    tiltm[0][0]=cs;
    tiltm[0][1]=-sn;
    tiltm[1][0]=sn;
    tiltm[1][1]=cs;

    tn=tan(halffov*pi/180);
    pm[0][0]=1;
    pm[2][2]=yon/(yon-hither)*tn;
    pm[2][3]=hither*yon/(hither-yon)*tn;
    pm[3][2]=tn;
    pm[1][1]=winSizeX/winSizeY;
}

void light(int n, double i, double x, double y, double z)
{
    lights[n].x=x;
    lights[n].y=y;
    lights[n].z=z;
    lights[n].i=i;
}

void disp()
{
#ifdef lab3
#ifndef PolyClip
    struct linetype lines;
#endif
    polygon *idx, tmp;
    vertex v, v2;
    col a,b,c;
    matrix temp;
    double x1,x2,y1,y2,z1,z2,w;

    mmult(eyem,eyet,eye);
    mmult(mirx,eye,temp);
    mmult(tiltm,temp,eye);
    mmult(pm,eye,GM);
    detail("EYE",eye);
    detail("PM",pm);
    detail("GM",GM);
    color=red;

    box((int)(0),(int)(winSizeX), (int)(0), (int)(winSizeY));
    idx=world.getnext();
    tmp.reset();
    while (idx!=NULL)
    {
#ifdef PolyClip
        idx->get(v);
        change(v,v2,GM);
        v.reset();
        clip(v2,&v);
#else
        idx->get(v2);
        change(v2,v,GM);
#endif
        if ((BackFaceElim==1) || (Shade==1))
        {
            v.get(x1,y1,z1,w,color);
            if (v.getnext()!=NULL)
            {
                v.getnext()->get(x2,y2,z2,w,color);
                a[0]=x1-x2;
                a[1]=y1-y2;
                a[2]=z1-z2;
                a[3]=1;
                if (v.getnext()->getnext()!=NULL) 
                {
                    v.getnext()->getnext()->get(x1,y1,z1,w,color);
                    b[0]=x2-x1;
                    b[1]=y2-y1;
                    b[2]=z2-z1;
                    b[3]=1;
                }
            }
            cross(a,b,c);
            if (c[2]<=0)
            {
                if (Shade==1) shade(v,c);
                perspective_div(v);
                tmp.add(v);
            }
        }
        else
        {
            perspective_div(v);
            tmp.add(v);
        }
        idx=idx->getnext();
    }
#ifndef PolyClip
    screen.reset();
    screen.addall(tmp);
    cosu_code(-1,1,-1,1, &lines);
    cosu_clip(-1,1,-1,1, &lines);
    draw(&lines);
#else
    draw(tmp);
#endif
#ifndef fast
  glFlush();     //Flushes the opengl buffer to execute the queued up instructions.
#endif
#endif
#ifdef lab4
    polygon *idx, tmp;
    vertex v, v2;
    col c,c2, view;
    GLfloat colr[4];
    matrix temp;
    double kd,ks,ni;
    double x1,y1,z1,w;

    mmult(eyem,eyet,eye);
    mmult(mirx,eye,temp);
    mmult(tiltm,temp,eye);
    mmult(pm,eye,GM);
    detail("EYE",eye);
    detail("PM",pm);
    detail("GM",GM);

    box((int)(0),(int)(winSizeX), (int)(0), (int)(winSizeY));
    idx=world.getnext();
    tmp.reset();
    while (idx!=NULL)
    {
        idx->get(v);
        v.getavg(x1,y1,z1);
        v.calcnormal(c);

        view[0]=eyex-x1;
        view[1]=eyey-y1;
        view[2]=eyez-z1;
        view[3]=0;
        unit(view);
        dot(c,view,w);

        if ((BackFaceElim==0) || (w>=-0.00000001))
        {
            idx->get(kd,ks,ni);
            v.getcolor(color);
            cmmult(eye,c,c2);
            calcolor(colr,color,c,view,kd,ks,ni,x1,y1,z1);
            //printout(c2,colr);
            change(v,v2,GM);
            v.reset();
            clip(v2,&v);
            perspective_div(v);
            v.calcnormal(c);
            v.get(x1,y1,z1);
            c[3]=-(c[0]*x1+c[1]*y1+c[2]*z1);
            tmp.add(v,kd,ks,ni,c,colr);           
        }
        idx=idx->getnext();
    }
    polyfill(tmp,winSizeX);
//    printlight();
//    draw(tmp);

#endif
}

#endif
