/******************************************************************************
 Author:  Michael Chungkun Chen
 SID:     002-764-157

 Version 1 = opengl.c  which was the skeleton code given by to us.
 Version 2 = lab1.c    which is built upon the skeleton.
 Version 3 = lab2.c    Gutted out lab1.c code, restructured, and entered new
                       code in.
 Version 4 = lab3.cc   Restructured lab2.c and entered new code.
 Version 5 = lab4.cc   Updated lab3.cc and entered lighting code.
  
 The code in this program I have typed out from scratch with the exception of
 the include.h file, half of the kbwait() function [I downloaded the earlier
 version which did not have the windows code and coded that part myself]. I
 also followed along the 3D clipping algorithm provided by the professor
 while coding it.  The <> header files are obviously not mine.

 This code was built upon the framework and existing code provided by the
 skeleton code.  All other code which constitutes a majority portion of this
 program was coded personally by me, with credit due to Bresenham for his
 line drawing algorithms and cirlce algorithms.  And Cohen-Sutherland and
 Sutherland-Broman for their line clipping and polygon clipping algorithms.

 From lab 2:
 I typed out my own parser from scratch.  And also due to unix
 being a multithreaded environment, I had to use my own strtok function
 named mstrtok()[the strtok kept returning erroneous results].  I believe
 the principles between the two functions are similar, it was a brute force
 reengineering job to code mstrtok().

 Certain portions -
 Copyright (C) 2001 Michael Chungkun Chen All Rights Reserved.
 *****************************************************************************/

//#define MATRIXOUT       //Enables Matrix output when defined.
#define PolyClip        //Enables 3d Polygon shading when defined.
#undef lab3             //This is not lab3
#define lab4            //Use lab4 routines
//#define fast            //Don't flush the GLbuffer until screen is drawn.


#include "include.h"    //Header files for GL, for windows and unix
#include "objtypes.h"   //Structures used for the objects
#include "functions.h"  //Functions
#include "matrix.h"     //Matrix Math
#include "bres.h"       //Bresenham Algorithms from lab1
#include "clipping.h"   //Clipping Algorithms for lab2
//#include "extra.h"      //Extra Credit Algorithms for lab2
#include "objectread.h" //Reads in objects
#include "structure.h"  //Vertex and Polygon list class
#include "parse.h"      //Parser for command script

VOIDCALLBACK displayFunc(void);

int main( int ac, char **av )
/*************************************************************************
This is the main program which allows a parameter line of 2 values specifying
the x and y window size.
**************************************************************************/
{
    char s[500];
    gets(s);
    
    winSizeX = atoi( mstrtok(s," ") );
    winSizeY = atoi( mstrtok(NULL," ") );

  /* Open GL window, ESC key kills window */
  auxInitDisplayMode( AUX_RGBA | AUX_SINGLE | AUX_ACCUM );
  auxInitPosition( 0, 0, winSizeX, winSizeY );
  auxInitWindow( "CS174 Window" );

  /* Set up for exposing, resizing, or moving windows */
  //This line caused abnormal behavior and was commented out by TA/Professor
  //auxReshapeFunc( reshapeCallback );

  /* Initialize GL environment */
  glClear( GL_COLOR_BUFFER_BIT );
  glLoadIdentity();
  glShadeModel( GL_FLAT );
  glFlush();

  /* Initializes*/
  colorb[0]=0;
  colorb[1]=0;
  colorb[2]=0;
  colorb[3]=1;
  r=0;
  b=0;
  g=0;
  ambient=0.25;
  light(1,0,10,10,0.8);

  hx=(double)(winSizeX)/(double)2;
  hy=(double)(winSizeY)/(double)2;
  cx=(int)((hx+0.5));
  cy=(int)((hy+0.5));

  ident(TM);
  ident(mirx);
  mirx[0][0]=-1;
  ident(GM);
  zero(pm);
  ident(eye);

  makeEye(0,0,5,0,0,0);
  makePM(0,0.1,1000,30);

  /* GL main loop */
  auxMainLoop( displayFunc );
  return 0;
}


VOIDCALLBACK displayFunc()
/*************************************************************************
Main loopback function
**************************************************************************/
{
  while (1==1)
  {
      lab3();
  }
  return;
}
