/*
This file implements the matrix mathematics.  Many unused matrix
operations are also implemented.

  Michael Chungkun Chen
  002-764-157
*/
#ifndef matrix_h
#define matrix_h

typedef double col[4];
typedef double matrix[4][4]; //[col][row]

void dot(col a, col b,double &c)
{
    c=a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3];
    return;
}

void magsq(col a,double &c)
{
    c=a[0]*a[0]+a[1]*a[1]+a[2]*a[2];
    return;
}

void cross(col a, col b, col c)
{
    c[0]=a[1]*b[2]-a[2]*b[1];
    c[1]=-a[0]*b[2]+a[2]*b[0];
    c[2]=a[0]*b[1]-a[1]*b[0];
    c[3]=0;
    return;
}

void unit(col &a)
{
    double mag;
    dot(a,a,mag);
    mag=sqrt(mag);
    if (mag==0) mag=1;
    a[0]=a[0]/mag;
    a[1]=a[1]/mag;
    a[2]=a[2]/mag;
    return;
}

void mmult(matrix A, matrix B, matrix c)
{
	c[0][0]=A[0][0]*B[0][0]+A[0][1]*B[1][0]+A[0][2]*B[2][0]+A[0][3]*B[3][0];
	c[0][1]=A[0][0]*B[0][1]+A[0][1]*B[1][1]+A[0][2]*B[2][1]+A[0][3]*B[3][1];
	c[0][2]=A[0][0]*B[0][2]+A[0][1]*B[1][2]+A[0][2]*B[2][2]+A[0][3]*B[3][2];
	c[0][3]=A[0][0]*B[0][3]+A[0][1]*B[1][3]+A[0][2]*B[2][3]+A[0][3]*B[3][3];
	c[1][0]=A[1][0]*B[0][0]+A[1][1]*B[1][0]+A[1][2]*B[2][0]+A[1][3]*B[3][0];
	c[1][1]=A[1][0]*B[0][1]+A[1][1]*B[1][1]+A[1][2]*B[2][1]+A[1][3]*B[3][1];
	c[1][2]=A[1][0]*B[0][2]+A[1][1]*B[1][2]+A[1][2]*B[2][2]+A[1][3]*B[3][2];
	c[1][3]=A[1][0]*B[0][3]+A[1][1]*B[1][3]+A[1][2]*B[2][3]+A[1][3]*B[3][3];
	c[2][0]=A[2][0]*B[0][0]+A[2][1]*B[1][0]+A[2][2]*B[2][0]+A[2][3]*B[3][0];
	c[2][1]=A[2][0]*B[0][1]+A[2][1]*B[1][1]+A[2][2]*B[2][1]+A[2][3]*B[3][1];
	c[2][2]=A[2][0]*B[0][2]+A[2][1]*B[1][2]+A[2][2]*B[2][2]+A[2][3]*B[3][2];
	c[2][3]=A[2][0]*B[0][3]+A[2][1]*B[1][3]+A[2][2]*B[2][3]+A[2][3]*B[3][3];
	c[3][0]=A[3][0]*B[0][0]+A[3][1]*B[1][0]+A[3][2]*B[2][0]+A[3][3]*B[3][0];
	c[3][1]=A[3][0]*B[0][1]+A[3][1]*B[1][1]+A[3][2]*B[2][1]+A[3][3]*B[3][1];
	c[3][2]=A[3][0]*B[0][2]+A[3][1]*B[1][2]+A[3][2]*B[2][2]+A[3][3]*B[3][2];
	c[3][3]=A[3][0]*B[0][3]+A[3][1]*B[1][3]+A[3][2]*B[2][3]+A[3][3]*B[3][3];
    return;
}

void cmmult(matrix A, col B, col c)
{
    c[0]=A[0][0]*B[0]+A[0][1]*B[1]+A[0][2]*B[2]+A[0][3]*B[3];
    c[1]=A[1][0]*B[0]+A[1][1]*B[1]+A[1][2]*B[2]+A[1][3]*B[3];
    c[2]=A[2][0]*B[0]+A[2][1]*B[1]+A[2][2]*B[2]+A[2][3]*B[3];
    c[3]=A[3][0]*B[0]+A[3][1]*B[1]+A[3][2]*B[2]+A[3][3]*B[3];
    return;
}


void madd(matrix A, matrix B, matrix c)
{
	int x,y;
	for (x=0; x<4; x++)
	{
		for(y=0;y<4;y++)
		{
			c[x][y]=A[x][y]+B[x][y];
		}
	}
    return;
}

void mneg(matrix A)
{
	int x,y;
	for (x=0; x<4; x++)
	{
		for(y=0;y<4;y++)
		{
			A[x][y]=-A[x][y];
		}
	}
    return;
}

void smult(matrix A, double s, matrix c)
{
	int x,y;
	for (x=0; x<4; x++)
	{
		for(y=0;y<4;y++)
		{
			c[x][y]=s*A[x][y];
		}
	}
    return;   
}

void scmult(col A, double s, col c)
{
	int x;
	for (x=0; x<4; x++)
	{
			c[x]=s*A[x];
	}
    return;   
}

void zero(matrix A)
{
	int x,y;
	for (x=0; x<4; x++)
	{
		for(y=0;y<4;y++)
		{
			A[x][y]=0;
		}
	}
    return;
}

void ident(matrix A)
{
	int x,y;
	for (x=0; x<4; x++)
	{
		for(y=0;y<4;y++)
		{
			if (x==y)
				A[x][y]=1;
			else
				A[x][y]=0;
		}
	}
    return;
}

void set(matrix A, matrix c)
{
	int x,y;
	for (x=0; x<4; x++)
	{
		for(y=0;y<4;y++)
		{
			c[x][y]=A[x][y];
		}
	}
    return;   
}



#endif
