/************************************************************************************
Thie header files handles the reading in of det file and asc files
*************************************************************************************/
#ifndef objectread_h
#define objectread_h

#include "structure.h"
#include "matrix.h"
#include <string.h>

char * ext(char *fn)
{
    char *ret;
    unsigned int i=0, j=0;
    while ((i<strlen(fn)) && (fn[i]!='.'))
    {
        i++;
    }
    ret=(char *)malloc(strlen(fn)-i+1);
    i++;
    while (i<strlen(fn))
    {
        ret[j++]=fn[i++];
    }
    ret[j]=0;
    return ret;
}

void readbinary(FILE *fin, class polygon &p, matrix TM, GLfloat clr[], double kd, double ks, double n)
{
    int verts,verts2, faces;
    int idx,i2,idx2;
    vertex v,w;
    polygon poly;
    float x,y,z;
    char *xp,*yp,*zp;
    unsigned char buf[5],ch;
    col b,c;
    vertex *varr;

    fread(&buf,1,4,fin);
    verts=0;
    fread(&ch,1,1,fin);
    verts+=ch;
    fread(&ch,1,1,fin);
    verts=verts*256+ch;
    faces=0;
    fread(&ch,1,1,fin);
    faces+=ch;
    fread(&ch,1,1,fin);
    faces=faces*256+ch;
    varr=(vertex *)malloc(sizeof(vertex)*verts);

    xp=(char *)&x;
    yp=(char *)&y;
    zp=(char *)&z;

    for(idx=0;idx<verts;idx++)
    {
        fread(&xp[3],1,1,fin);
        fread(&xp[2],1,1,fin);
        fread(&xp[1],1,1,fin);
        fread(&xp[0],1,1,fin);

        fread(&yp[3],1,1,fin);
        fread(&yp[2],1,1,fin);
        fread(&yp[1],1,1,fin);
        fread(&yp[0],1,1,fin);

        fread(&zp[3],1,1,fin);
        fread(&zp[2],1,1,fin);
        fread(&zp[1],1,1,fin);
        fread(&zp[0],1,1,fin);
        
        b[0]=x;
        b[1]=y;
        b[2]=z;
        b[3]=1;
        cmmult(TM,b,c);
       
        varr[idx].set(c[0],c[1],c[2],c[3],clr);
    }

    poly.reset();
    for(idx=0;idx<faces;idx++)
    {
        i2=0;
        fread(&ch,1,1,fin);
        i2+=ch;
        fread(&ch,1,1,fin);
        i2=i2*256+ch;
        verts2=i2;
        v.reset();
        for (idx2=0;idx2<verts2;idx2++)
        {
            i2=0;
            fread(&ch,1,1,fin);
            i2+=ch;
            fread(&ch,1,1,fin);
            i2=i2*256+ch;
            v.add(varr[i2-1]);
        }
        w=v.getnext();
        poly.add(w);
        poly.getlast()->set(kd,ks,n);
    }
    p=poly.getnext();
    free(varr);
    v.reset();
    w.reset();
    poly.reset();
}

void readtext(FILE *fin, class polygon &p, matrix TM, GLfloat clr[], double kd, double ks, double n)
{
    int verts,verts2, faces;
    int idx,i2,idx2,i;
    vertex v,w;
    polygon poly;
    double xxx,yyy,zzz;
    col b,c;
    char ch,s[50];
    int flag;
    vertex *varr;
    
    i=0;
    s[i]=0;
    ch=10;
    flag=0;
    while (((ch!=32) && ((ch!=13) && (ch!=10))) || (flag==0))
    {
        if ((ch!=32) && ((ch!=13) && (ch!=10))) flag=1;
        fread(&ch,1,1,fin);
        s[i++]=ch;
    }
    s[i]=0;
    verts=atoi(s);

    i=0;
    s[i]=0;
    ch=10;
    flag=0;
    while (((ch!=32) && ((ch!=13) && (ch!=10))) || (flag==0))
    {
        if ((ch!=32) && ((ch!=13) && (ch!=10))) flag=1;
        fread(&ch,1,1,fin);
        s[i++]=ch;
    }
    s[i]=0;
    faces=atoi(s);

    varr=(vertex *)malloc(sizeof(vertex)*verts);

    for(idx=0;idx<verts;idx++)
    {
        i=0;
        s[i]=0;
        ch=10;
        flag=0;
        while (((ch!=32) && ((ch!=13) && (ch!=10))) || (flag==0))
        {
            if ((ch!=32) && ((ch!=13) && (ch!=10))) flag=1;
            fread(&ch,1,1,fin);
            s[i++]=ch;
        }
        s[i]=0;
        xxx=atof(s);

        i=0;
        s[i]=0;
        ch=10;
        flag=0;
        while (((ch!=32) && ((ch!=13) && (ch!=10))) || (flag==0))
        {
            if ((ch!=32) && ((ch!=13) && (ch!=10))) flag=1;
            fread(&ch,1,1,fin);
            s[i++]=ch;
        }
        s[i]=0;
        yyy=atof(s);

        i=0;
        s[i]=0;
        ch=10;
        flag=0;
        while (((ch!=32) && ((ch!=13) && (ch!=10))) || (flag==0))
        {
            if ((ch!=32) && ((ch!=13) && (ch!=10))) flag=1;
            fread(&ch,1,1,fin);
            s[i++]=ch;
        }
        s[i]=0;
        zzz=atof(s);
        
        b[0]=xxx;
        b[1]=yyy;
        b[2]=zzz;
        b[3]=1;
        cmmult(TM,b,c);
       
        varr[idx].set(c[0],c[1],c[2],c[3],clr);
    }

    poly.reset();
    for(idx=0;idx<faces;idx++)
    {
        i=0;
        s[i]=0;
        ch=10;
        flag=0;
        while (((ch!=32) && ((ch!=13) && (ch!=10))) || (flag==0))
        {
            if ((ch!=32) && ((ch!=13) && (ch!=10))) flag=1;
            fread(&ch,1,1,fin);
            s[i++]=ch;
        }
        s[i]=0;
        verts2=atoi(s);

        v.reset();
        for (idx2=0;idx2<verts2;idx2++)
        {
            i=0;
            s[i]=0;
            ch=10;
            flag=0;
            while (((ch!=32) && ((ch!=13) && (ch!=10))) || (flag==0))
            {
                if ((ch!=32) && ((ch!=13) && (ch!=10))) flag=1;
                fread(&ch,1,1,fin);
                s[i++]=ch;
            }
            s[i]=0;
            i2=atoi(s);
            v.add(varr[i2-1]);
        }
        w=v.getnext();
        poly.add(w);
        poly.getlast()->set(kd,ks,n);
    }
    p=poly.getnext();
    free(varr);
    v.reset();
    w.reset();
    poly.reset();
}

void readobject(char *fn, class polygon &p, matrix TM, GLfloat c[], double kd, double ks, double n)
{
    FILE *fin;
    if (strcmp(ext(fn),"det")==0)
    {
        fin=fopen(fn,"rb");
        readbinary(fin, p,TM,c,kd,ks,n);
    }
    else if(strcmp(ext(fn),"asc")==0)
    {
        fin=fopen(fn,"r");
        readtext(fin,p, TM,c,kd,ks,n);
    }
    fclose(fin);
}

#endif
