/*
This header file defines all the common structures and constants.
It also implements the clearing functions.

  Michael Chungkun Chen
  002-764-157
*/
#ifndef objtypes_def  //Insures that structures are declared
#define objtypes_def  //only once.

#include "include.h"    //Header files for GL, for windows and unix
#include "structure.h"  //Vertex and Polygon list class
#include "matrix.h"     //Matrix Math

#define TOP		0x0001
#define BOTTOM	0x0002
#define LEFT	0x0004
#define RIGHT	0x0008

int winSizeX, winSizeY;
double hx,hy;
int cx,cy;

#define pi 3.1415926535897932384626433832795028841971693993751058209749445923078164862862089980348253471679

GLfloat white[4] = {1.0, 1.0, 1.0, 1.0};    //The color white
GLfloat black[4] = {0.0, 0.0, 0.0, 0.0};    //The lack of color black
GLfloat   red[4] = {1.0, 0.0, 0.0, 1.0};    //Red
GLfloat green[4] = {0.0, 1.0, 0.0, 1.0};    //Green
GLfloat  blue[4] = {0.0, 0.0, 1.0, 1.0};    //Blue
GLfloat    gb[4] = {0.0, 1.0, 1.0, 1.0};    //Cyan
GLfloat    rg[4] = {1.0, 1.0, 0.0, 1.0};    //Yellow
GLfloat    rb[4] = {1.0, 0.0, 1.0, 1.0};    //Magenta
GLfloat *color,colorb[4],colori[4];         //Color holder.  Uses this color to draw.

GLfloat *face[6]={white,red,blue,green,gb,black};

#define sFRONT      0;
#define sBOTTOM     1;
#define sRIGHT      2;
#define sTOP        3;
#define sLEFT       4;
#define sBACK       5;

matrix TM, eye, pm, mirx, GM, eyem,eyet,tiltm;
int BackFaceElim=1, Shade=0;
double r=0,b=0,g=0, eyex,eyey,eyez;
double ambient;
polygon world, screen;

struct light
/***************************************************************************
Keeps track of one of the lights
***************************************************************************/
{
  double x,y,z;           //Coordinates of vertex
  double i;               //intensity
} lights[10];

struct ptlst
/***************************************************************************
  The ptlst structure is a link list of points, it is mostly used to keep
  an ordered list of vertex in a given polygon.  The vertex are stored in
  the reverse order that the user draws them at.
***************************************************************************/
{
  double x,y,z;           //Coordinates of vertex
  struct ptlst *next;     //Pointer to next vertex
};

struct linetype
/***************************************************************************
  The linetype structure is a link list of lines, it is mostly used to keep
  an list of lines with their clipping codes.
***************************************************************************/
{
	double x,y,z,x2,y2,z2;
	int code1,code2;
	GLfloat *color;
	struct linetype *next;
};

struct polytype
{ polytype *next;
  ptlst *pts;
  GLfloat *color;
};

void clearline(struct linetype *lines)
/*************************************************************************
The clearline function clears the line structure and frees memory.
**************************************************************************/
{
  struct linetype *l, *l2;
  
  l=lines;			  //Begin at start
  while (l!=NULL)     //Traverse all lines
    {
      l2=l->next;     //Remember location    
      free(l);        //Free memory from polygon structure
      l=l2;           //Go on to next polygon
    }
}

#endif      //Skip all of this if structures are already defined.




