/*************************************************************************************
This header contains the command parsing engine.
**************************************************************************************/
#ifndef parse_h
#define parse_h

char *stptr, *stleft, dlim[4];

char *mstrtok(char *in,const char *delim)
{
    char *temp;
    int index;

    if (in==NULL)
    {
        if (stleft[0]==0)
            return NULL;
        temp=stleft;
        index=0;
        while ((strchr(delim,temp[index])!=NULL) && (temp[index]!=0))
            index++;
        stptr=&temp[index];
        if (temp[index]==0)
        {
            stptr=NULL;
            return stptr;
        }
        while ((strchr(delim,temp[index])==NULL) && (temp[index]!=0))
            index++;
        if (temp[index]!=0)
            stleft=&temp[index+1];
        else
            stleft=&temp[index];
        temp[index]=0;
    }
    else
    {
        temp=in;
        index=0;
        while ((strchr(delim,temp[index])!=NULL) && (temp[index]!=0))
            index++;
        stptr=&in[index];
        if (temp[index]==0)
        {
            stptr=NULL;
            return stptr;
        }
        while ((strchr(delim,temp[index])==NULL) && (temp[index]!=0))
            index++;
        if (temp[index]!=0)
            stleft=&temp[index+1];
        else
            stleft=&temp[index];
        temp[index]=0;
    }
    return stptr;
}

VOIDCALLBACK lab3(void)
{
  char *token;
  char string[500], s2[500];
  polygon poly;
  double sx,sy,sz,rx,ry,rz, tilt, hither, yon, halffov;
  double kd,ks,n,rr,bb,gg, intense;
  int i;

  dlim[0]=32;
  dlim[1]=10;
  dlim[2]=13;
  dlim[3]=0;

  gets(string);

  if ((token=mstrtok((char *)string,dlim))!=NULL)
  {
    if (strcmp(token,"#")==0)
    {
        //This line is a comment
    }
    else if (strcmp(token,"scale")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sx=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sy=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sz=atof(token);
		    else
			    printf("Invalid parameter.\n");
		    scale(TM,sx,sy,sz);
            detail("Scale",TM);
    }
    else if (strcmp(token,"rotate")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    rx=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    ry=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    rz=atof(token);
		    else
			    printf("Invalid parameter.\n");

            rotate(TM,rx,ry,rz);
            detail("Rotate",TM);
    }
    else if (strcmp(token,"translate")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sx=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sy=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sz=atof(token);
		    else
			    printf("Invalid parameter.\n");
            translate(TM,sx,sy,sz);
            detail("Translate",TM);
    }
    else if (strcmp(token,"reset")==0)
    {
		ident(TM);
        BackFaceElim=1;
        Shade=0;
    }
    else if (strcmp(token,"noBackface")==0)
    {
        BackFaceElim=1;
    }
    else if (strcmp(token,"nobackfaces")==0)
    {
        BackFaceElim=1;
    }
    else if (strcmp(token,"backface")==0)
    {
        BackFaceElim=0;
    }
    else if (strcmp(token,"backfaces")==0)
    {
        BackFaceElim=0;
    }
#ifdef shading
    else if (strcmp(token,"shade")==0)
    {
        Shade=1;
    }
    else if (strcmp(token,"Shade")==0)
    {
        Shade=1;
    }
#endif
    else if (strcmp(token,"light")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
                i=atoi(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                intense=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                rx=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                ry=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                rz=atof(token);
            else
			    printf("Invalid parameter.\n");
        light(i,intense,rx,ry,rz);        
    }
    else if (strcmp(token,"ambient")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
                n=atof(token);
            else
			    printf("Invalid parameter.\n");
        ambient=n;
    }
    else if (strcmp(token,"background")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
                rr=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                bb=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                gg=atof(token);
            else
			    printf("Invalid parameter.\n");
        colorb[0]=rr;
        colorb[1]=bb;
        colorb[2]=gg;
        colorb[3]=1;
    }
    else if (strcmp(token,"object")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    strcpy(s2,token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                rr=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                bb=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                gg=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                kd=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                ks=atof(token);
            else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
                n=atof(token);
            else
			    printf("Invalid parameter.\n");
        colori[0]=rr;
        colori[1]=bb;
        colori[2]=gg;
        colori[3]=1;
        printf("Loading object...\n");
        readobject(s2,poly,TM,colori,kd,ks,n);
        world.addall(poly);
    }
    else if (strcmp(token,"observer")==0)
    {
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sx=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sy=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    sz=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    rx=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    ry=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    rz=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    tilt=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    hither=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    yon=atof(token);
		    else
			    printf("Invalid parameter.\n");
        if ((token=mstrtok(NULL,dlim))!=NULL)
			    halffov=atof(token); 
		    else
			    printf("Invalid parameter.\n");

        makeEye(sx,sy,sz,rx,ry,rz);
        makePM(tilt,hither,yon,halffov);
    }
    else if (strcmp(token,"display")==0)
    {
		glClear( GL_COLOR_BUFFER_BIT );
		glFlush();
        printf("Displaying Image...\n");
        disp();
		kbwait();
    }
    else if (strcmp(token,"clearData")==0)
    {
		world.reset();
    }
    else if (strcmp(token,"clearScreen")==0)
    {
		glClear( GL_COLOR_BUFFER_BIT );
		glFlush();
		kbwait();
    }
    else if (strcmp(token,"end")==0)
    {
		world.reset();
        auxQuit();
    }
    else
    {
        printf("The command entered is invalid: %s\n", token);
    }
  }
  return;
}
#endif
