/*************************************************************************************
This header file setups the classes for vertex and polygons
**************************************************************************************/
#ifndef structure_h
#define structure_h

#include "include.h"
#include "matrix.h"

class vertex
{
public:
    vertex();
    vertex(double xx, double yy, double zz, double ww=0, GLfloat *cc=NULL);
    get(double &xx, double &yy, double &zz, double &ww, GLfloat *&cc);
    get(double &xx, double &yy, double &zz);
    getavg(double &xx, double &yy, double &zz);
    get(double &xx, double &yy);
    calcnormal(col &normal);
    set(double xx, double yy, double zz, double ww=0, GLfloat *cc=NULL);
    vertex *getnext();
    vertex *gethead();
    round();
    int same();
    sethead(vertex *n);
    add(double xx, double yy, double zz, double ww=0, GLfloat *cc=NULL);
    add(vertex v);
    reset();
    getcolor(GLfloat *&c);
    setcolor(GLfloat *c);
    vertex operator=(vertex node); 
    vertex *operator=(vertex *node); 
    ~vertex();
private:
    double x, y, z, w;
    vertex *head;
    vertex *next;
    vertex *end;
    GLfloat color[4];
};

class line
{
public:
    line();
    line(vertex x, vertex y);
    line(double x1,double y1, double z1, double x2, double y2, double z2);
    setcode(int x,int y);
    getcode(int &x,int &y);
    get(vertex &x, vertex &y);
    set(vertex x, vertex y);
    line *getnext();
    line *gethead();
    sethead(line *n);
    add(vertex x, vertex y);
    add(line v);
    reset();
    line operator=(line node); 
    line *operator=(line *node); 
    ~line();

    setcolor(GLfloat *c);
private:
    vertex one, two;
    int code1, code2;
    GLfloat *color;
    line *next;
    line *head;
};

class polygon
{
public:
    polygon();
    polygon(vertex node);
    polygon *getnext();
    polygon *gethead();
    polygon *getlast();
    add(vertex node);
    get(vertex &node);
    get(col &n);
    get(double &d, double &s, double &ni);
    add(vertex node, double d, double s, double ni, col norm);
    add(vertex node, double d, double s, double ni, col norm, GLfloat *col);
    set(vertex node);
    get(GLfloat col[]);
    set(GLfloat *col);
    set(col n);
    set(double d, double s, double ni);
    add(polygon poly);
    addall(polygon poly);
    reset();
    polygon operator=(polygon node); 
    polygon *operator=(polygon *node); 
    ~polygon();

private:
    vertex v;
    double kd, ks, n;
    col normal;
    GLfloat color[4];
    polygon *head;
    polygon *next;
    polygon *end;
};

polygon::polygon()
{
    kd=0;
    ks=0;
    n=0;
    head=NULL;
    next=NULL;
    end=this;
}

polygon::polygon(vertex node)
{
    kd=0;
    ks=0;
    n=0;
    head=NULL;
    next=NULL;
    v=node;
    end=this;
}

class polygon *polygon::getnext()
{
    return next;
}

class polygon *polygon::getlast()
{
    return head->end;
}

class polygon *polygon::gethead()
{
    return head;
}

polygon::get(vertex &node)
{
    node=v;
}

polygon::get(col &n)
{
    n[0]=normal[0];
    n[1]=normal[1];
    n[2]=normal[2];
    n[3]=normal[3];
}

polygon::get(GLfloat col[])
{
    col[0]=color[0];
    col[1]=color[1];
    col[2]=color[2];
    col[3]=color[3];
}

polygon::get(double &d, double &s, double &ni)
{
    d=kd;
    s=ks;
    ni=n;
}

polygon::add(vertex node)
{
    polygon *idx;
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    idx=head->end;
    idx->next=new polygon();
    idx=idx->getnext();
    idx->v=node;
    idx->head=head;
    idx->next=NULL;
    end=idx;
}

polygon::add(vertex node, double d, double s, double ni, col norm)
{
    polygon *idx;
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    idx=head->end;
    idx->next=new polygon();
    idx=idx->getnext();
    idx->v=node;
    idx->kd=d;
    idx->ks=s;
    idx->n=ni;
    idx->normal[0]=norm[0];
    idx->normal[1]=norm[1];
    idx->normal[2]=norm[2];
    idx->normal[3]=norm[3];
    idx->head=head;
    idx->next=NULL;
    end=idx;
}

polygon::add(vertex node, double d, double s, double ni, col norm, GLfloat *col)
{
    polygon *idx;
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    idx=head->end;
    idx->next=new polygon();
    idx=idx->getnext();
    idx->v=node;
    idx->kd=d;
    idx->ks=s;
    idx->n=ni;
    idx->normal[0]=norm[0];
    idx->normal[1]=norm[1];
    idx->normal[2]=norm[2];
    idx->normal[3]=norm[3];
    idx->color[0]=col[0];
    idx->color[1]=col[1];
    idx->color[2]=col[2];
    idx->color[3]=col[3];
    idx->head=head;
    idx->next=NULL;
    end=idx;
}

polygon::add(polygon poly)
{
    polygon *idx;
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    idx=head->end;
    idx->next=new polygon();
    idx=idx->getnext();
    poly.get(idx->v);
    poly.get(idx->normal);
    poly.get(idx->kd,idx->ks,idx->n);
    poly.get(idx->color);
    idx->head=head;
    idx->next=NULL;
    end=idx;
}

polygon::addall(polygon poly)
{
    polygon *idx;
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    idx=head->end;
    idx->next=new polygon();
    idx=idx->getnext();
    poly.get(idx->v);
    poly.get(idx->normal);
    poly.get(idx->kd,idx->ks,idx->n);
    poly.get(idx->color);
    idx->head=head;
    idx->next=new polygon();
    (*idx->next)=poly.next;
    end=idx->next->end;
}

polygon::set(double d, double s, double ni)
{
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    kd=d;
    ks=s;
    n=ni;
}

polygon::set(vertex n)
{
    v.reset();
    v=n;
    if (head==NULL)
    {
        head=this;
        end=this;
    }
}

polygon::set(GLfloat *col)
{
    color[0]=col[0];
    color[1]=col[1];
    color[2]=col[2];
    color[3]=col[3];

    if (head==NULL)
    {
        head=this;
        end=this;
    }
}

polygon::set(col n)
{
    normal[0]=n[0];
    normal[1]=n[1];
    normal[2]=n[2];
    normal[3]=n[3];

    if (head==NULL)
    {
        head=this;
        end=this;
    }
}

polygon::reset()
{
    v.reset();
    head=this;
    end=this;
    if (next!=NULL)
    {
        next->reset();
        delete next;
        next=NULL;
    }
}

class polygon polygon::operator=(polygon node)
{
    v=node.v;
    next=new polygon(node.next->v);
    kd=node.kd;
    ks=node.ks;
    n=node.n;
    normal[0]=node.normal[0];
    normal[1]=node.normal[1];
    normal[2]=node.normal[2];
    normal[3]=node.normal[3];
    color[0]=node.color[0];
    color[1]=node.color[1];
    color[2]=node.color[2];
    color[3]=node.color[3];
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    next->next=new polygon;
    next->head=head;
    (*next->next)=node.next->next;
    end=next->next;
    return *this;
}

class polygon *polygon::operator=(polygon *node)
{
    if (node!=NULL)
    {
        v=node->v;
        ks=node->ks;
        kd=node->kd;
        n=node->n;
        normal[0]=node->normal[0];
        normal[1]=node->normal[1];
        normal[2]=node->normal[2];
        normal[3]=node->normal[3];
        color[0]=node->color[0];
        color[1]=node->color[1];
        color[2]=node->color[2];
        color[3]=node->color[3];
        if (head==NULL)
        {
            head=this;
            end=this;
        }
        if (node->next!=NULL)
        {
            next=new polygon(node->next->v);
            next->ks=node->next->ks;
            next->kd=node->next->kd;
            next->n=node->next->n;
            next->normal[0]=node->next->normal[0];
            next->normal[1]=node->next->normal[1];
            next->normal[2]=node->next->normal[2];
            next->normal[3]=node->next->normal[3];
            next->color[0]=node->next->color[0];
            next->color[1]=node->next->color[1];
            next->color[2]=node->next->color[2];
            next->color[3]=node->next->color[3];
            next->head=head;
            next->next=new polygon;
            if (node->next->next!=NULL)
            {
                (*next->next)=node->next->next;
                end=next->next->end;
            }
            else
            {
                next->next=NULL;
                end=next;
            }
        }
        else
        {
            next=NULL;
            end=this;
        }
    }
    return this;
}

polygon::~polygon()
{
/*    polygon *idx, *idx2;
    if (head==NULL)
        head=this;
    idx=head;
    while (idx!=NULL)
    {
        idx2=idx;
        idx=idx->getnext();
        delete idx2;
    }*/
}

line::line()
{
    color=NULL;
}

line::line(vertex x, vertex y)
{
    one=x;
    two=y;
    color=NULL;
}

line::line(double x1,double y1, double z1, double x2, double y2, double z2)
{
    one.set(x1,y1,z1);
    two.set(x2,y2,z2);
}
line::setcolor(GLfloat *c)
{
    color=c;
}

vertex::vertex()
{
    x=0;
    y=0;
    z=0;
    w=0;
    color[0]=0;
    color[1]=0;
    color[2]=0;
    color[3]=0;
    next=NULL;
    head=NULL;
    end=this;
}

vertex::vertex(double xx, double yy, double zz, double ww, GLfloat *cc)
{
    x=xx;
    y=yy;
    z=zz;
    w=ww;
    color[0]=cc[0];
    color[1]=cc[1];
    color[2]=cc[2];
    color[3]=cc[3];
    head=NULL;
    next=NULL;
    end=this;
}

vertex::get(double &xx, double &yy)
{
    xx=x;
    yy=y;
}

vertex::get(double &xx, double &yy, double &zz)
{
    xx=x;
    yy=y;
    zz=z;
}

vertex::getavg(double &xx, double &yy, double &zz)
{
    vertex *idx;
    double xt,yt,zt;
    unsigned long int count;

    idx=head;
    xt=0;
    yt=0;
    zt=0;
    count=0;
    while (idx!=NULL)
    {
        xt+=idx->x;
        yt+=idx->y;
        zt+=idx->z;
        count++;
        idx=idx->next;
    }
    if (count==0) count=1;
    xx=xt/count;
    yy=yt/count;
    zz=zt/count;
}

vertex::calcnormal(col &normal)
{
    col a, b;
    double x2,y2,z2,x3,y3,z3,w;
    GLfloat *c;
    
    if (next!=NULL)
    {
       next->get(x2,y2,z2,w,c);
       a[0]=x-x2;
       a[1]=y-y2;
       a[2]=z-z2;
       a[3]=0;
       if (next->next!=NULL) 
       {
          next->next->get(x3,y3,z3,w,c);
          b[0]=x3-x2;
          b[1]=y3-y2;
          b[2]=z3-z2;
          b[3]=0;
       }
    }
    cross(a,b,normal);
    unit(normal);
}

vertex::get(double &xx, double &yy, double &zz, double &ww, GLfloat *&cc)
{
    xx=x;
    yy=y;
    zz=z;
    ww=w;
    cc=color;
}

vertex::set(double xx, double yy, double zz, double ww, GLfloat *cc)
{
    x=xx;
    y=yy;
    z=zz;
    w=ww;
    color[0]=cc[0];
    color[1]=cc[1];
    color[2]=cc[2];
    color[3]=cc[3];
}

vertex *vertex::getnext()
{
    return next;
}

vertex *vertex::gethead()
{
    return head;
}

vertex::add(double xx, double yy, double zz, double ww, GLfloat * cc)
{
    vertex *idx;
    if (head==NULL)
        head=this;
    idx=head;
    idx=idx->end;
    idx->next=new vertex(xx,yy,zz,ww,cc);
    idx=idx->getnext();
    idx->head=head;
    head->end=idx;
}

vertex::add(vertex v)
{
    vertex *idx;
    GLfloat *cc;
    if (head==NULL)
        head=this;
    idx=head;
    idx=idx->end;
    idx->next=new vertex();
    idx=idx->getnext();
    v.get(idx->x,idx->y,idx->z, idx->w, cc);
    idx->color[0]=cc[0];
    idx->color[1]=cc[1];
    idx->color[2]=cc[2];
    idx->color[3]=cc[3];
    idx->head=head;
    idx->next=NULL;
    head->end=idx;
}

vertex::round()
{
    vertex *idx;
    idx=head->end;
    idx->next=head;
    idx=head;
    head=idx->getnext();
    idx->next=NULL;
}

int vertex::same()
{
    vertex *idx;
    double delt=0.00001;
    double x1,y1,z1,w1,x2,y2,z2,w2;
    GLfloat * cc;
    if (head==NULL)
        return 1;
    idx=head;
    idx->get(x2,y2,z2,w2,cc);
    while (idx->getnext()!=NULL)
    {
        x1=x2;
        y1=y2;
        z1=z2;
        w1=w2;
        idx=idx->getnext();
        idx->get(x2,y2,z2,w2,cc);
        if (((x2-x1>delt) || (y2-y1>delt)) || ((z2-z1>delt)||(w2-w1>delt)))
            return 0;
    }
    return 1;
}

vertex vertex::operator=(vertex node)
{
    x=node.x;
    y=node.y;
    z=node.z;
    w=node.w;
    color[0]=node.color[0];
    color[1]=node.color[1];
    color[2]=node.color[2];
    color[3]=node.color[3];
    if (head==NULL) head=this;
    if (node.next!=NULL)
    {
        next=new vertex(node.next->x,node.next->y,node.next->z,node.next->w,node.next->color);
        next->head=head;
        if (node.next->next!=NULL)
        {
            next->next=new vertex;
            (*next->next)=node.next->next;
            end=next->next->end;
        }
        else next->next=NULL;
        end=next;
    }
    else
    {
        next=NULL;
        end=this;
    }
    return *this;
}

vertex *vertex::operator=(vertex *node)
{
    if (head==NULL)
    {
        head=this;
        end=this;
    }
    if (node!=NULL)
    {
        x=node->x;
        y=node->y;
        z=node->z;
        w=node->w;
        color[0]=node->color[0];
        color[1]=node->color[1];
        color[2]=node->color[2];
        color[3]=node->color[3];
        if (node->next!=NULL)
        {
            next=new vertex(node->next->x,node->next->y,node->next->z, node->next->w, node->next->color);
            next->head=head;
            next->next=new vertex;
            next->next->head=head;
            if (node->next->next!=NULL)
            {
                (*next->next)=node->next->next;
                end=next->next->end;
            }
            else
            {
                next->next=NULL;
                end=next->end;
            }
        }
        else
        {
            next=NULL;
            end=this;
        }
    }
    return this;
}

vertex::reset()
{
    x=0;
    y=0;
    z=0;
    w=0;
    head=this;
    end=this;
    if (next!=NULL)
    {
        next->reset();
        delete next;
        next=NULL;
    }
}

vertex::sethead(vertex *n)
{
    head=n;
}

vertex::getcolor(GLfloat *&c)
{
    c=(GLfloat *)&color;
}

vertex::setcolor(GLfloat *c)
{
    color[0]=c[0];
    color[1]=c[1];
    color[2]=c[2];
    color[3]=c[3];
}

vertex::~vertex()
{
/*   void *idx, *idx2;
    if (head==NULL)
        head=this;
    idx=head;
    while (idx!=NULL)
    {
        idx2=idx;
        idx=((vertex *)idx)->getnext();
        delete (vertex *)idx2;
    }*/
}

line::get(vertex &x, vertex &y)
{
    x=one;
    y=two;
}

line::set(vertex x, vertex y)
{
    one=x;
    two=y;
}

line::setcode(int x, int y)
{
    code1=x;
    code2=y;
}

line::getcode(int &x, int &y)
{
    x=code1;
    y=code2;
}

line *line::getnext()
{
    return next;
}

line *line::gethead()
{
    return head;
}

line::add(vertex x, vertex y)
{
    line *idx;
    if (head==NULL)
        head=this;
    idx=head;
    while (idx->getnext()!=NULL)
    {
        idx=idx->getnext();
    }
    idx->next=new line(x,y);
    idx=idx->getnext();
    idx->head=head;
}

line::add(line l)
{
    line *idx;
    if (head==NULL)
        head=this;
    idx=head;
    while (idx->getnext()!=NULL)
    {
        idx=idx->getnext();
    }
    idx->next=new line();
    idx=idx->getnext();
    l.get(idx->one,idx->two);
    l.getcode(idx->code1,idx->code2);
    idx->head=head;
    idx->next=NULL;
}

line line::operator=(line node)
{//here.
    double x1,x2,y1,y2,z1,z2,w1,w2;
    GLfloat *c;
    vertex v, vv;
    code1=node.code1;
    code2=node.code2;
    one=node.one;
    two=node.two;
    (node.getnext())->get(v,vv);
    v.get(x1,y1,z1,w1,c);
    vv.get(x2,y2,z2,w2,c);
    next=new line(x1,y1,z1,x2,y2,z2);
    head=node.head;
    next->next=new line;
    (*next->next)=node.next->next;
    next->head=head;
    return *this;
}

line *line::operator=(line *node)
{
    double x1,x2,y1,y2,z1,z2,w1,w2;
    GLfloat *c;
    vertex v, vv;
    code1=node->code1;
    code2=node->code2;
    one=node->one;
    two=node->two;
    (node->getnext())->get(v,vv);
    v.get(x1,y1,z1,w1,c);
    vv.get(x2,y2,z2,w2,c);
    head=node->head;
    if (node->next!=NULL)
    {
        next=new line(x1,y1,z1,x2,y2,z2);
        next->head=head;
        next->next=new line;
        (*next->next)=node->next->next;
    }
    else
    {
        next=NULL;
    }
    return this;
}

line::reset()
{
    code1=0;
    code2=0;
    one.reset();
    two.reset();
    head=this;
    if (next!=NULL)
    {
        next->reset();
        delete next;
        next=NULL;
    }
}

line::sethead(line *n)
{
    head=n;
}

line::~line()
{
/*   void *idx, *idx2;
    if (head==NULL)
        head=this;
    idx=head;
    while (idx!=NULL)
    {
        idx2=idx;
        idx=((vertex *)idx)->getnext();
        delete (vertex *)idx2;
    }*/
}

void back(vertex &v, vertex &v2)
{
    vertex *idx;
    GLfloat *c;
    int i,j;
    double x,y,z,w;
    vertex *arr[9999];
    idx=v.gethead();
    i=0;
    while (idx!=NULL)
    {
        arr[i++]=idx;
        idx=idx->getnext();
    }
    v2.reset();
    arr[i]->get(x,y,z,w,c);
    v2.set(x,y,z,w,c);
    for (j=i-1;j>=0;j--)
    {
        arr[j]->get(x,y,z,w,c);
        v2.add(x,y,z,w,c);
    }
}


#endif
